package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author liuyj
 * @date 2022/8/5 09:59
 */
@Getter
@AllArgsConstructor
public enum SceneClassificationEnum {
    OTHER_SCENE(1, "其他场景"),
    FIRST_SALON(2, "一面沙龙"),
    DIRECTOR_SALON(3, "总监运营沙龙"),
    VIEW_COMMUNITY(4, "参观社区"),
    VIEW_CSH(5, "各类产说会"),
    VIEW_KQHD(6, "各类客情活动"),
    CUST_INTERVIEW(7, "客户面访"),
    ;

    private Integer code;

    private String desc;

    public static SceneClassificationEnum getByCode(Integer code) {
        for (SceneClassificationEnum invitationStatusEnum : SceneClassificationEnum.values()) {
            if (invitationStatusEnum.getCode().equals(code)) {
                return invitationStatusEnum;
            }
        }
        return null;
    }
}
