package cn.com.duiba.oto.dto.oto.pet.order;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2025/4/12 09:13
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteOrderDetailWashDto extends RemoteOrderDetailBaseDto {

    private static final long serialVersionUID = -838842268647340981L;
    // 服务项目
    private List<ServiceItemVO> serviceItems;

    @Data
    public static class ServiceItemVO implements Serializable {
        private static final long serialVersionUID = 140816508008132118L;
        /**
         * 当天的宠物列表
         */
        List<PetItemVO> petItemVOS;
        /**
         * 服务日期
         */
        private String serviceDate;
        /**
         * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
         *
         * @see cn.com.duiba.oto.enums.pet.PetDoorTypeEnum
         */
        private Integer doorType;
        /**
         * 服务时间段，如 "10:00-12:00"
         */
        private String timeRange;
        /**
         * 服务时间段：1=上午，2=下午，3=晚上
         * @see cn.com.duiba.oto.enums.pet.PetTimeSlotEnum
         */
        private Integer appointmentTimeSlot;

        /**
         * 安排上门时间
         */
        private Date appointmentTime;
        /**
         * 服务价格，单位为分
         */
        private Long price;
        /**
         * 加价金额（节假日和非常规时间加价）
         */
        private Long addPrice;

        /**
         * 是否节假日
         */
        private Boolean holiday;

        /**
         * 是否常规时间
         */
        private Boolean regularTime;
    }


    @Data
    public static class PetItemVO implements Serializable {
        private static final long serialVersionUID = 380533467017577129L;
        /**
         * 宠物ID
         */
        private Long petId;
        /**
         * 宠物名称
         */
        private String petName;
        /**
         * 宠物洗护服务项目
         */
        private List<PetItemSubVO> petItemSubVOS;
        /**
         * 合计
         */
        private Long total;
    }

    @Data
    public static class PetItemSubVO implements Serializable {
        private static final long serialVersionUID = -8056011239371737937L;
        /**
         * 服务项目
         * @see cn.com.duiba.oto.enums.pet.PetWashTypeEnum
         * @see cn.com.duiba.oto.enums.pet.PetWashBaseEnum
         */
        private Integer serviceItemId;

        /**
         * 服务项目名称
         */
        private String serviceItemName;

        /**
         * 服务价格，单位为分
         */
        private Long price;
    }
}
