package cn.com.duiba.oto.enums.deal;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 成单：缴费方式
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum PaymentMethodEnum {

    YEAR(1, "年交"),
    MONTH(2, "月交"),
    QUARTER(3, "季度交"),
    ;

    private static final Map<Integer, PaymentMethodEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PaymentMethodEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    PaymentMethodEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PaymentMethodEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
