package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.oto.dto.oto.cust.CustomerInfoDto;
import cn.com.duiba.oto.param.oto.cust.CustomerInfoSaveParam;
import cn.com.duiba.oto.param.oto.cust.CustomerInfoUpdateParam;

import java.util.List;

/**
 * 客户关键信息远程服务接口
 *
 * @author xiaotian
 * @date 2024-12-18
 */
public interface RemoteCustomerInfoService {

    /**
     * 根据客户ID获取客户关键信息
     *
     * @param custId 客户ID
     * @return 客户关键信息
     */
    CustomerInfoDto getCustomerInfo(Long custId);

    /**
     * 根据客户ID列表批量获取客户关键信息
     *
     * @param custIds 客户ID列表
     * @return 客户关键信息列表
     */
    List<CustomerInfoDto> getCustomerInfos(List<Long> custIds);

    /**
     * 保存客户关键信息
     *
     * @param param 保存参数
     * @return 保存结果
     */
    boolean saveCustomerInfo(CustomerInfoSaveParam param);

    /**
     * 更新客户关键信息
     *
     * @param param 更新参数
     * @return 更新结果
     */
    boolean updateCustomerInfo(CustomerInfoUpdateParam param);

    /**
     * 批量保存客户关键信息
     *
     * @param params 保存参数列表
     * @return 保存结果
     */
    boolean batchSaveCustomerInfos(List<CustomerInfoSaveParam> params);

    /**
     * 更新客户高潜状态
     *
     * @param custId 客户ID
     * @param highPotential 是否高潜客户
     * @return 更新结果
     */
    boolean updateHighPotential(Long custId, Integer highPotential);

    /**
     * 更新客户保险购买经历
     *
     * @param custId 客户ID
     * @param hasInsurance 是否买过保险
     * @return 更新结果
     */
    boolean updateHasInsurance(Long custId, Integer hasInsurance);

    /**
     * 更新客户抗保状态
     *
     * @param custId 客户ID
     * @param antiGuarantee 是否抗保
     * @return 更新结果
     */
    boolean updateAntiGuarantee(Long custId, Integer antiGuarantee);

    /**
     * 更新客户现金流情况
     *
     * @param custId 客户ID
     * @param cashFlow 现金流情况
     * @return 更新结果
     */
    boolean updateCashFlow(Long custId, Integer cashFlow);

    /**
     * 更新客户不动产情况
     *
     * @param custId 客户ID
     * @param realEstate 不动产情况
     * @return 更新结果
     */
    boolean updateRealEstate(Long custId, Integer realEstate);

    /**
     * 更新客户家庭结构
     *
     * @param custId 客户ID
     * @param familyStructure 家庭结构
     * @return 更新结果
     */
    boolean updateFamilyStructure(Long custId, String familyStructure);

    /**
     * 更新客户退休金信息
     *
     * @param custId 客户ID
     * @param pension 退休金
     * @return 更新结果
     */
    boolean updatePension(Long custId, String pension);

    /**
     * 统计高潜客户数量
     *
     * @return 高潜客户数量
     */
    long countHighPotentialCustomers();

    /**
     * 统计有保险购买经历的客户数量
     *
     * @return 有保险购买经历的客户数量
     */
    long countCustomersWithInsurance();

    /**
     * 根据客户ID删除客户关键信息
     *
     * @param custId 客户ID
     * @return 删除结果
     */
    boolean deleteCustomerInfo(Long custId);

    /**
     * 检查客户关键信息是否存在
     *
     * @param custId 客户ID
     * @return 是否存在
     */
    boolean existsCustomerInfo(Long custId);
}
