package cn.com.duiba.oto.param.oto.cust;

import lombok.Data;

import java.io.Serializable;

/**
 * 客户关键信息更新参数
 *
 * @author xiaotian
 * @date 2024-12-18
 */
@Data
public class CustomerInfoUpdateParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 客户ID
     */
    private Long custId;

    /**
     * 是否高潜客户：0=否，1=是
     * {@link cn.com.duiba.oto.enums.cust.info.HighPotentialEnum}
     */
    private Integer highPotential;

    /**
     * 家庭结构
     */
    private String familyStructure;

    /**
     * 是否买过保险：0=否，1=是
     * {@link cn.com.duiba.oto.enums.cust.info.HasInsuranceEnum}
     */
    private Integer hasInsurance;

    /**
     * 是否抗保：0=否，1=是
     * {@link cn.com.duiba.oto.enums.cust.info.AntiGuaranteeEnum}
     */
    private Integer antiGuarantee;

    /**
     * 现金流情况（1:50w以下 2:50w-100w 3:100w-200w 4:200w以上）
     * {@link cn.com.duiba.oto.enums.cust.info.CashFlowEnum}
     */
    private Integer cashFlow;

    /**
     * 不动产情况（1:1-2套 2:3-4套 3:5套及以上 0:无）
     */
    private String realEstate;

    /**
     * 退休金
     */
    private String pension;
}
