package cn.com.duiba.oto.param.oto.cust.form;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：提交表单详情参数
 *
 * @Auther: xiaotian
 * @Date: 2023/2/27 09:25
 * @Description:
 */
@Data
public class RemoteCustFormSubmitParam implements Serializable {
    private static final long serialVersionUID = 4283727048158239016L;

    /**
     * 资料表单id
     */
    private Long groupId;

    /**
     * 客户id
     */
    private Long custId;

    private Long operatorId;

    /**
     * 答案列表
     */
    private List<QuestionParam> questionParams;


    @Data
    public static class QuestionParam implements Serializable {

        private static final long serialVersionUID = 5113653267023632907L;
        /**
         * 问题id
         */
        private Long id;

        /**
         * 答案列表
         */
        private List<QuestionAnswerParam> answers;
    }


    @Data
    public static class QuestionAnswerParam implements Serializable {

        private static final long serialVersionUID = -5742187931117014150L;

        /**
         * 选项code
         */
        private String code;

        /**
         * 填写项
         * type === other 或者天空题时用户提交会有text字段
         */
        private String text;
    }
}
