package cn.com.duiba.oto.dto.oto.activity.wuye;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 物业活动配置信息
 */
@Data
public class WuyeActivityConfigDto implements Serializable {

    private static final long serialVersionUID = -6076726894875125532L;

    /**
     * 顺序 1:校园活动 2:牙齿活动
     */
    private Integer index;

    /**
     * 活动类型：自定义活动类型，必须
     *
     * @link BizActivityTypeEnum.WUYE_AVTIVITY.getType() 开头
     */
    private String activityType;

    /**
     * logo图片
     */
    private String logo;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 小区名称
     */
    private String community;

    /**
     * 活动时间文案
     */
    private String activityDateDesc;

    /**
     * 活动时间
     */
    private List<String> activityDate;

    /**
     * 活动名额
     */
    private String activityNum;

    /**
     * 分享图片
     */
    private String shareImg;

    /**
     * 分享标题
     */
    private String shareTitle;
}