package cn.com.duiba.oto.enums.cust;

import com.google.common.collect.Sets;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Set;

/**
 * @author chenzhenxing
 * @date 2022/4/7 2:47 下午
 */
@Getter
@AllArgsConstructor
public enum
OtoCustAbandonReasonTypeEnum {
    VACANT_NUMBER(1, "空号或错号"),
    CUSTOMER_NO_MONEY(2, "客户没钱"),
    OTHER(3, "其他"),
    EXIT_GROUP_CUSTOMER(4, "已存在同组客户"),
    NULL_NUMBER(5, "空号"),
    ERROR_NUMBER(6, "错号（客户表示没填）"),
    BLACK_CUST(7, "黑名单客户"),
    ;

    private static final Set<Integer> GARBAGE_POOL_CUST_SET = Sets.newHashSet(VACANT_NUMBER.getCode(),
            EXIT_GROUP_CUSTOMER.getCode(), NULL_NUMBER.getCode(), ERROR_NUMBER.getCode(), BLACK_CUST.getCode());
    private final Integer code;
    private final String desc;

    public static boolean putGarbagePoolFlag(Integer code) {
        return GARBAGE_POOL_CUST_SET.contains(code);
    }
}
