package cn.com.duiba.oto.enums.goods.order;

import lombok.Getter;

import java.util.Arrays;

/**
 * @Description
 * @Author huliangsheng
 * @Date 2024/8/15 11:00
 */
@Getter
public enum OrderStatusEnum {

    TO_BE_PAID(0, "待支付"),
    PAID(1, "已付款"),
    VERIFY(2, "已完成"),
    REFUNDED(3, "已退款"),
    REFUND_ING(4, "退款中");


    private Integer status;

    private String desc;

    public static OrderStatusEnum getByStatus(Integer status) {
        return Arrays.stream(OrderStatusEnum.values()).filter(item -> item.getStatus().equals(status)).findFirst().get();
    }

    OrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }
}
