package cn.com.duiba.oto.oto.service.api.remoteservice.sign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.bean.CommunitySignConfigBean;
import cn.com.duiba.oto.dto.oto.sign.CommunitySignConfigDto;

import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2024/9/6 10:25
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteCommunitySignConfigService {

    /**
     * 获取配置
     *
     * @return
     */
    List<CommunitySignConfigBean> configList();

    /**
     * 获取机构配置
     */
    List<CommunitySignConfigBean> getCommunityConfigList();

    /**
     * 新增配置
     *
     * @param communitySignConfigDto
     * @return
     */
    boolean save(CommunitySignConfigDto communitySignConfigDto);

    /**
     * 获取最新配置
     *
     * @return
     */
    CommunitySignConfigDto getLastConfig(Integer configIndex);
}
