/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust.info;

public enum CashFlowEnum {
    BELOW_50W(1, "50\u4e07\u4ee5\u4e0b"),
    BETWEEN_50W_100W(2, "50\u4e07-100\u4e07"),
    BETWEEN_100W_200W(3, "100\u4e07-200\u4e07"),
    ABOVE_200W(4, "200\u4e07\u4ee5\u4e0a");

    private final Integer code;
    private final String desc;

    public static CashFlowEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (CashFlowEnum item : CashFlowEnum.values()) {
            if (!item.getCode().equals(code)) continue;
            return item;
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        CashFlowEnum item = CashFlowEnum.getByCode(code);
        return item != null ? item.getDesc() : null;
    }

    public static boolean isHighCashFlow(Integer code) {
        return ABOVE_200W.getCode().equals(code);
    }

    public static boolean isMediumHighCashFlow(Integer code) {
        return BETWEEN_100W_200W.getCode().equals(code) || ABOVE_200W.getCode().equals(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private CashFlowEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}

