package cn.com.duiba.oto.dto.oto.wx.material;

import cn.com.duiba.oto.bean.wx.WxBaseResponse;
import cn.com.duiba.oto.enums.WxErrorCodeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author xiaotian
 * @date 2020/11/11 8:42 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper=true)
public class DownloadFileBean extends WxBaseResponse {
    private static final long serialVersionUID = 3682584418276350085L;

    /**
     * 经过处理后，上传到oss的完整地址
     */
    private String url;

    public static DownloadFileBean unSupport() {
        DownloadFileBean downloadFileBean = new DownloadFileBean();
        downloadFileBean.setErrCode(WxErrorCodeEnum.E_12.getCode());
        downloadFileBean.setErrMsg(WxErrorCodeEnum.E_12.getDesc());
        return downloadFileBean;
    }

    public static DownloadFileBean success(String wxCodeUnLimit) {
        DownloadFileBean downloadFileBean = new DownloadFileBean();
        downloadFileBean.url = wxCodeUnLimit;
        return downloadFileBean;
    }

    public static DownloadFileBean unKnowException() {
        DownloadFileBean downloadFileBean = new DownloadFileBean();
        downloadFileBean.setErrCode(WxErrorCodeEnum.E_8.getCode());
        downloadFileBean.setErrMsg(WxErrorCodeEnum.E_8.getDesc());
        return downloadFileBean;
    }
}

