package cn.com.duiba.oto.enums.cust.info;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 高潜客户枚举
 *
 * @author xiaotian
 * @date 2024-12-18
 */
@Getter
@AllArgsConstructor
public enum HighPotentialEnum {

    /**
     * 否
     */
    NO(0, "否"),

    /**
     * 是
     */
    YES(1, "是");

    /**
     * 编码
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据编码获取枚举
     *
     * @param code 编码
     * @return 枚举
     */
    public static HighPotentialEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (HighPotentialEnum item : values()) {
            if (item.getCode().equals(code)) {
                return item;
            }
        }
        return null;
    }

    /**
     * 根据编码获取描述
     *
     * @param code 编码
     * @return 描述
     */
    public static String getDescByCode(Integer code) {
        HighPotentialEnum item = getByCode(code);
        return item != null ? item.getDesc() : null;
    }

    /**
     * 判断是否为高潜客户
     *
     * @param code 编码
     * @return 是否为高潜客户
     */
    public static boolean isHighPotential(Integer code) {
        return YES.getCode().equals(code);
    }
}
