package cn.com.duiba.oto.dto.oto.separate;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户剥离详情表
 *
 * @TableName tb_oto_cust_separate
 */
@Data
public class CustSeparateDto implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 客户id
     */
    private Long custId;
    /**
     * 销售id
     */
    private Long sellerId;
    /**
     * 检测类型 1:面访 2:成单
     */
    private Integer checkType;
    /**
     * 下次检测时间
     */
    private Date checkTime;
    /**
     * 角色类型 4:专家 5：邀约
     */
    private Integer roleType;
    /**
     * 展示状态: 1:展示 0:不展示 2:超时 -1:删除
     */
    private Integer showFlag;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 最新的审批记录id
     */
    private Long separateOrderId;
}