package cn.com.duiba.oto.enums.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * OTO 流程组名称
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustBulletinBoardV2Enum {
    /**
     * 客户经营看板2.0
     */
    ASSIGN_CUSTOMER_LINK(1, "历史承接客户数"),
    ABANDON_CUSTOMER_LINK(2, "放弃客户数"),
    ASSIGN_AGAIN_CUSTOMER_LINK(3, "被改派客户数"),
    FOLLOW_CUSTOMER_LINK(4, "当前还在跟进客户数"),
    INVITE_CUSTOMER_LINK(5, "邀约来的客户数"),
    DIRECTOR_ASSIGN_LINK(6, "被总监分配的客户数"),
    SEAS_CUSTOMER_LINK(7, "捞取公海的客户数"),
    ONESELF_CUSTOMER_LINK(8, "自己录入的客户数"),
    CUSTOMER_STAR_LINK(9, "星标客户数"),
    DEAL_LINK(10, "成单客户数"),
    ;

    private static final Map<Integer, CustBulletinBoardV2Enum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustBulletinBoardV2Enum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    CustBulletinBoardV2Enum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustBulletinBoardV2Enum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
