package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-10-09 16:55
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteInviteCustListSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 6939120829236186248L;

    /**
     * 具体的客户id列表
     */
    private List<Long> custIds;

    /**
     * 客户名称/客户id
     */
    private String params;

    /**
     * 账户ID集合
     */
    private List<String> launchAccountIds;
    /**
     * 客户手机号（可查备用手机号）
     */
    private List<String> custPhones;

    /**
     * 客户来源
     *
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private List<String> custFromSourceList;

    /**
     * 入库时间（开始）
     */
    private Date createTimeStart;

    /**
     * 入库时间（结束）
     */
    private Date createTimeEnd;

    /**
     * 承接时间（开始）
     */
    private Date continueTimeStart;

    /**
     * 承接时间（结束）
     */
    private Date continueTimeEnd;

    /**
     * 激活时间（开始）
     */
    private Date activeTimeStart;

    /**
     * 激活时间（结束）
     */
    private Date activeTimeEnd;

    /**
     * 资源池
     */
    private List<Integer> poolTypes;

    /**
     * 专家id
     */
    private List<Long> expertIds;

    /**
     * 邀约id
     */
    private List<Long> inviteIds;

    /**
     * 是否呼出
     */
    private Integer callOut;

    /**
     * 是否接通
     */
    private Integer callConnect;

    /**
     * 是否应邀
     */
    private Integer custInvite;

    /**
     * 是否到场
     */
    private Integer custPresent;

    /**
     * 是否鸽子
     */
    private Integer custDove;

    /**
     * 年龄开始
     */
    private Integer ageStart;

    /**
     * 年龄结束
     */
    private Integer ageEnd;

    /**
     * 标签ID
     */
    private List<Long> tagIds;

    /**
     * 客户等级
     */
    private List<Integer> custLevel;

    /**
     * 是否星标客户 1：是 0 ：否
     */
    private Integer custStar;

    /**
     * 是否高质量用户  1：是 0 ：否
     */
    private Integer inviteStar;

    /**
     * 是否社区高客  1：是 0 ：否
     */
    private Integer communityStar;

    /**
     * 是否标记成单 0否 1是
     */
    private Integer dealFlag;

}
