package cn.com.duiba.oto.dto.oto.goods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Author huliangsheng
 * @Date 2024/8/14 14:28
 */
@Data
public class GoodsDetail implements Serializable {

    private static final long serialVersionUID = 1220085817764510885L;
    /**
     * 商品id
     */
    private Long id;
    /**
     * 商品标题
     */
    private String goodsTitle;
    /**
     * 商品头图
     */
    private String imgUrl;
    /**
     * 商品原价图片
     */
    private String goodsOriginalImage;
    /**
     * 商品详情图
     */
    private String detailImgUrl;
    /**
     * 商品规格
     */
    private String standard;
    /**
     * 商品描述
     */
    private String goodsDesc;
    /**
     * 商品有效期
     */
    private Date validPeriod;
    /**
     * 原价
     */
    private Integer originalPrice;
    /**
     * 优惠价
     */
    private Integer favourPrice;
    /**
     * 剩余库存数
     */
    private Integer remainStocks;
    /**
     * 实际库存
     */
    private Integer actualStocks;
    /**
     * 限购数
     */
    private Integer limitBuyCount;
    /**
     * 上架时间
     */
    private Date saleTime;
    /**
     * 商品上架状态
     * -1:下架 0:未上架 1:待上架 2:上架中
     */
    private Integer saleStatus;
}
