package cn.com.duiba.oto.dto.oto.sign;


import lombok.Data;

import java.io.Serializable;

/**
 * 客户当前签到任务详情
 */
@Data
public class SignSubmitDto implements Serializable {
    private static final long serialVersionUID = -7036990808830898483L;

    /**
     * 任务签到天数
     */
    private Integer taskDay;

    /**
     * 已签到天数
     */
    private Integer signDay;

    /**
     * 已签到总天数
     */
    private Integer allSignDays;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品id
     */
    private Long prizeId;

    /**
     * 奖品图片
     */
    private String prizeImg;

    /**
     * 本次签到是否成功
     */
    private Boolean sign = true;

    /**
     * 本次签到的立减金数量（分）
     * 为0，则表示本次签到没有立减金奖励
     */
    private Integer amount = 0;

    /**
     * 本次签到是否获得奖品
     */
    private Boolean prizeFlag = false;

}