package cn.com.duiba.oto.dto.oto.pet;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * tb_oto_pet
 *
 * @author
 */
@Data
public class OtoPetSubOrderDto implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 子订单ID
     */
    private Long id;
    /**
     * 主订单ID（外键）
     */
    private Long orderMainId;
    /**
     * 宠物ID
     */
    private Long petId;
    /**
     * 服务类型：1:正常
     */
    private Integer serviceType;
    /**
     * 服务日期
     */
    private Date appointmentDate;
    /**
     * 服务时间段，如 "10:00-12:00"
     */
    private String appointmentTimeRange;
    /**
     * 服务价格（单位：分）
     */
    private Long servicePrice;

    /**
     * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
     */
    private Integer doorType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 服务状态：0=待服务，1=已服务，2=用户取消，3=商家取消
     */
    private Integer serviceStatus;
}