package cn.com.duiba.oto.param.oto.interview;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 描述：面访记录生成
 *
 * @author xiaotian
 * @date 2023-04-28
 */
@Data
public class InterviewBizTypeAddParam implements Serializable {

    private static final long serialVersionUID = -3694745511179493992L;

    /**
     * 来源 1:扫码面访 2：用户自己签到 3：补签 4：销售提报
     * @see cn.com.duiba.oto.enums.interview.CustInterviewBizTypeEnum
     */
    Integer bizType;

    /**
     * 来源id
     */
    String bizId;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 面访场景配置ID 【tb_cust_interview_conf】
     */
    private Long interviewConfId;

    /**
     * 见面目的 1-1进2，2-2进3/2进4，3-3进，0-关系维护维护
     */
    private Integer custPhase;

    /**
     * 面访类型
     * {@link cn.com.duiba.oto.enums.interview.InterviewTypeEnum}
     */
    private Integer interviewType;

    /**
     * 预约参观时间
     */
    private Date appointmentTime;

    /**
     * 该参数 为了区分是否是补签来的 默认false
     */
    private boolean signSource = false;
}
