package cn.com.duiba.oto.enums.rights;

import java.util.stream.Stream;

/**
 * 功能描述：权益刷新类型
 *
 * @Auther: xiaotian
 * @Date: 2023/11/20 17:55
 * @Description:
 */
public enum RightRefreshTypeEnum {

    NONE(1, "不刷新"),
    MONTH(2, "月度"),
    YEAR(3, "年度");

    private Integer type;

    private String desc;

    RightRefreshTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static RightRefreshTypeEnum getByType(Integer code) {
        if (code == null) {
            return null;
        }
        return Stream.of(RightRefreshTypeEnum.values()).filter(rightTypeEnum -> rightTypeEnum.getType().equals(code)).findFirst().orElse(null);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
