package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 看板查询参数
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardQueryParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 维度：team=团队数据, person=个人数据
     */
    private String dimension;

    /**
     * 团队名称（可选）
     */
    private String teamName;

    /**
     * 销售ID（个人数据时需要）
     */
    private Long sellerId;

    /**
     * 销售ID列表（团队数据时可传多个）
     */
    private List<Long> sellerIds;

    /**
     * 开始月份，例如 2025-07
     */
    private String startMonth;

    /**
     * 结束月份，例如 2025-09
     */
    private String endMonth;

    /**
     * 单个月份，例如 2025-09
     */
    private String month;

    /**
     * 年份，例如 2025
     */
    private Integer year;
}

