package cn.com.duiba.oto.enums.cust.info;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 是否买过保险枚举
 *
 * @author xiaotian
 * @date 2024-12-18
 */
@Getter
@AllArgsConstructor
public enum HasInsuranceEnum {

    /**
     * 否
     */
    NO(0, "否"),

    /**
     * 是
     */
    YES(1, "是");

    /**
     * 编码
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据编码获取枚举
     *
     * @param code 编码
     * @return 枚举
     */
    public static HasInsuranceEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (HasInsuranceEnum item : values()) {
            if (item.getCode().equals(code)) {
                return item;
            }
        }
        return null;
    }

    /**
     * 根据编码获取描述
     *
     * @param code 编码
     * @return 描述
     */
    public static String getDescByCode(Integer code) {
        HasInsuranceEnum item = getByCode(code);
        return item != null ? item.getDesc() : null;
    }

    /**
     * 判断是否买过保险
     *
     * @param code 编码
     * @return 是否买过保险
     */
    public static boolean hasInsurance(Integer code) {
        return YES.getCode().equals(code);
    }
}
