package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;

/**
 * 产说会活动数据DTO
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardMeetingDataDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 月份，例如 2025-09
     */
    private String month;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 产说会活动量
     */
    private Integer activityCount;

    /**
     * 新接客户总数
     */
    private Integer newClients;

    /**
     * 国内险件数
     */
    private Integer domesticCases;

    /**
     * 高客种草活动量
     */
    private Integer highCustGrassCount;

    /**
     * 已成交高客数
     */
    private Integer highCustDealCount;

    /**
     * 已种草客户总数（累计）
     */
    private Integer totalGrassCount;

    /**
     * 10到3指标：(1 - 未参加产说会新客户数 / 新接客户总数)
     */
    private Double rate103;

    /**
     * 3出1指标：国内险件数 / 产说会活动量
     */
    private Double rate3o1;

    /**
     * 高客种草率：高客种草活动量 / 已种草客户总数
     */
    private Double grassRate;

    /**
     * 种草高客成交率（5出1指标）：已成交高客数 / 已种草客户总数
     */
    private Double grassDealRate;
}

