package cn.com.duiba.oto.dto.oto.sign;


import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * oto社区签到配置表
 *
 * @TableName tb_oto_community_sign_config
 */
@Data
public class CommunitySignConfigDto implements Serializable {
    private static final long serialVersionUID = -9101317137047512621L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 签到类型
     */
    private String configType;

    /**
     * 主题
     */
    private String configTheme;

    /**
     * 时间
     */
    private Date configTime;

    /**
     * 地址
     */
    private String configAddress;

    /**
     * 头图
     */
    private String configImage;

    /**
     * 流程图
     */
    private String configFlowImage;

    /**
     * 其余参数
     *
     * @see cn.com.duiba.oto.bean.activity.CommunitySignExtraConfigBean
     */
    private String extraParam;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 配置顺序
     */
    private Integer configIndex;
}