package cn.com.duiba.oto.param.oto.pet;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2025/4/14 09:56
 * @Description:
 */
@Data
public class RemoteOrderCalculateParam implements Serializable {

    private static final long serialVersionUID = 8182969904481562114L;
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 地址ID
     */
    @NotNull
    private Long addressId;
    /**
     * 宠物ID
     */
    @NotEmpty
    private List<ServiceItem> serviceItems;

    @Data
    public static class ServiceItem implements Serializable {
        private static final long serialVersionUID = -5183084901099907701L;
        /**
         * 服务日期
         * yyyy-MM-dd
         */
        @NotNull
        private String serviceDate;

        /**
         * 服务时间段，如 "10:00-12:00"
         * HH:mm-HH:mm
         */
        private String timeRange;

        /**
         * 宠物ID列表
         */
        private List<Long> petIds;

        /**
         * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
         *
         * @see cn.com.duiba.oto.enums.pet.PetDoorTypeEnum
         */
        @NotNull
        private Integer doorType;
    }
}
