package cn.com.duiba.oto.dto.oto.wx;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * tb_oto_wx_users_ext
 *
 * @author
 */
@Data
public class WxUsersExtDto implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_oto_wx_users.id
     */
    private Long userId;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 公众号是否已关注：0=未关注、1=已关注
     */
    private Integer subscribe;

    /**
     * 类型：oa=公众号、mp=小程序
     */
    private String extType;

    /**
     * 微信接口返回 access_token，用户解密敏感数据, 小程序为session_key
     */
    private String accessToken;

    /**
     * 微信接口返回 refresh_token
     */
    private String refreshToken;

    /**
     * 公众号id
     */
    private Long oaId;

    /**
     * 第一次关注时间
     */
    private Date firstSubscribeTime;

    /**
     * 最后一次关注时间
     */
    private Date lastSubscribeTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    private static final long serialVersionUID = 1L;
}