package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;

/**
 * 成交客户数据DTO
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardDealDataDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 月份，例如 2025-09
     */
    private String month;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 加保客户数
     */
    private Integer addKeepClients;

    /**
     * 高客成交数
     */
    private Integer highValueDeals;

    /**
     * 转介绍成交数
     */
    private Integer referralDeals;

    /**
     * 缘故成交数
     */
    private Integer acquaintanceDeals;

    /**
     * 成交总数
     */
    private Integer dealTotal;

    /**
     * 已成交客户数：加保客户数 - 高客成交数 - 转介绍成交数 - 缘故成交数
     */
    private Integer dealClients;
}

