package cn.com.duiba.oto.enums.deal;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 成单：证件类型
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum CertificateTypeEnum {

    ID_CARD(1, "居民身份证"),
    PASSPORT(2, "护照"),
    HKAndMC(3, "港澳居民来往内地通行证"),
    TAILAND(4, "台湾居民来往大陆通行证"),
    FOREIGNERS(5, "外国人居留证"),
    OTHER(6, "其他身份证件");;

    private static final Map<Integer, CertificateTypeEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CertificateTypeEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    CertificateTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CertificateTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
