package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 经营池数据表格DTO
 * 继承BoardTableDto，并添加列分组信息
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BusinessPoolTableDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 表格列信息列表
     * 第一列固定为"分组"，后续列为各个指标名称及其描述
     */
    private List<BoardTableColumnDto> columns;

    /**
     * 表格列分组信息列表
     * 用于表示表头的分组信息，如"类型"、"经营数据"、"经营指标"、"高客经营表现"等
     * 每个分组包含分组名称和该分组包含的列索引范围（从startIndex开始，包含colspan列）
     */
    private List<BoardTableColumnGroupDto> columnGroups;

    /**
     * 表格行数据列表
     * 包含分组行和总计行
     */
    private List<BoardTableRowDto> rows;
}

