package cn.com.duiba.oto.enums.pet;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 宠物服务类型
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum PetServiceTypeEnum {
    /**
     * 上门喂养
     */
    FEEDING(1, "上门喂养"),
    /**
     * 上门洗护
     */
    WASH(2, "上门洗护"),
    ;

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetServiceTypeEnum::getCode, PetServiceTypeEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public static PetServiceTypeEnum getByCode(Integer code) {
        for (PetServiceTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
