package cn.com.duiba.oto.param.oto.pet.channel;

import lombok.Data;

import java.io.Serializable;

/**
 * 功能描述：更新渠道参数
 *
 * @Auther: xiaotian
 * @Date: 2025/6/26
 * @Description:
 */
@Data
public class RemotePetChannelUpdateParam implements Serializable {
    private static final long serialVersionUID = -5804877385799690439L;
    /**
     * 渠道ID
     */
    private Long id;
    /**
     * 物业名称
     */
    private String propertyName;
    /**
     * 小区名称
     */
    private String communityName;
    /**
     * BD负责人
     */
    private String bdLeader;
    /**
     * 结算方式 (1-物业结算, 2-小区结算)
     */
    private Integer settlementMethod;
    /**
     * 额外字段（JSON格式），如果同时传入 trafficFee 和 extraParam，trafficFee 会覆盖 extraParam 中的 trafficFee
     * @see cn.com.duiba.oto.bean.pet.PetChannelExtraParamBean
     */
    private String extraParam;
}

