/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.activity;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ActivityStatusEnum {
    START(1, "\u4e0a\u67b6"),
    END(0, "\u4e0b\u67b6");

    private static final Map<Integer, ActivityStatusEnum> INNER_MAP;
    private final Integer code;
    private final String desc;

    private ActivityStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityStatusEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        INNER_MAP = Collections.unmodifiableMap(Arrays.stream(ActivityStatusEnum.values()).collect(Collectors.toMap(ActivityStatusEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    }
}

