package cn.com.duiba.oto.enums.pet;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 宠物体型
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum PetSizeEnum {
    /**
     * 小型
     */
    SAMLL(1, "小型"),
    /**
     * 大型
     */
    BIG(2, "大型"),
    ;

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetSizeEnum::getCode, PetSizeEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }
}
