package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;

/**
 * 客户池数据DTO
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardCustomerPoolDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 月份，例如 2025-09
     */
    private String month;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 新接客户总数
     */
    private Integer newClients;

    /**
     * 转介绍客户数
     */
    private Integer referralClients;

    /**
     * 缘故客户
     */
    private Integer acquaintanceClients;

    /**
     * 客户总数（月度新接客户 + 转介绍 + 缘故 - 脱落）
     */
    private Integer totalClients;
}

