package cn.com.duiba.oto.oto.service.api.remoteservice.board;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.board.BoardQueryParam;
import cn.com.duiba.oto.dto.oto.board.BoardTableDto;
import cn.com.duiba.oto.dto.oto.board.BusinessPoolTableDto;

/**
 * 看板数据远程服务接口
 * <p>
 * 根据表格看板HTML功能需求，提供以下主要接口：
 * 1. 经营池数据表格：显示新接客户总数、产说会活动量、国内险件数、10到3、3出1、当月高客种草量、高客种草累计、成交高客数、种草高客成交率等指标
 * 2. 客户池数据表格：显示新接客户总数、保有客户数、转介绍客户数、缘故客户数、客户总数
 * 3. 成交客户池数据表格：显示加保客户数、高客成交数、转介绍成交数、缘故成交数、客户总数
 * 4. 收入数据表格：显示当月业绩、当月件数、累积业绩、累积件数、当月收入、累积收入
 * <p>
 * 数据来源：所有数据均基于 tb_oto_board_data_raw 表结构
 * <p>
 * 所有表格接口均支持：
 * - 维度筛选：team（团队指标）或 person（个人指标）
 * - 团队筛选：个人维度时可选择特定团队或全部
 * - 月份筛选：部分模块支持月份筛选（收入模块不支持月份筛选，显示当月和累积）
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@AdvancedFeignClient
public interface RemoteOtoBoardService {

    /**
     * 获取经营池数据表格
     * <p>
     * 返回表格数据，包含以下列：
     * - 分组（团队名或人员名）
     * - 新接客户总数（来自new_clients字段）
     * - 产说会活动量（来自activity_count字段）
     * - 国内险件数（来自domestic_cases字段）
     * - 10到3（产说会活动量 / 新接客户总数）
     * - 3出1（国内险件数 / 产说会活动量）
     * - 当月高客种草量（来自high_cust_grass_count字段）
     * - 高客种草累计（累计所有月份的高客种草量，来自total_grass_count字段）
     * - 成交高客数（来自high_cust_deal_count字段）
     * - 种草高客成交率（成交高客数 / 高客种草累计）
     * <p>
     * 维度说明：
     * - team（团队指标）：只需要传入月份，内部会根据团队内的销售数据聚合，展示每个团队一行
     * - person（个人指标）：需要传入月份，如果传入teamId则只查询该团队下的销售数据，否则查询所有销售数据，展示每个销售一行
     * <p>
     * 包含分组行和总计行
     *
     * @param param 查询参数
     *              - dimension: team（团队指标）或 person（个人指标），必填
     *              - month: 月份，例如 "7月"、"8月"、"9月"，必填
     *              - teamId: 团队ID（部门ID），个人指标时可选：传入时只查询该团队下的销售，不传时查询所有销售；团队指标时不需要此参数
     * @return 表格数据（包含列名、列分组信息和行数据）
     */
    BusinessPoolTableDto getBusinessPoolTable(BoardQueryParam param);

    /**
     * 获取客户池数据表格
     * <p>
     * 返回表格数据，包含以下列：
     * - 分组（团队名或人员名）
     * - 新接客户总数（来自new_clients字段）
     * - 保有客户数（来自retained_clients字段）
     * - 转介绍客户数（来自referral_clients字段）
     * - 缘故客户数（来自acquaintance_clients字段）
     * - 客户总数（来自total_clients字段，或计算：新接 + 保有 + 转介绍 + 缘故）
     * <p>
     * 维度说明：
     * - team（团队指标）：只需要传入月份，内部会根据团队内的销售数据聚合，展示每个团队一行
     * - person（个人指标）：需要传入月份，如果传入teamId则只查询该团队下的销售数据，否则查询所有销售数据，展示每个销售一行
     * <p>
     * 包含分组行和总计行
     *
     * @param param 查询参数
     *              - dimension: team（团队指标）或 person（个人指标），必填
     *              - month: 月份，例如 "7月"、"8月"、"9月"，必填
     *              - teamId: 团队ID（部门ID），个人指标时可选：传入时只查询该团队下的销售，不传时查询所有销售；团队指标时不需要此参数
     * @return 表格数据（包含列名和行数据）
     */
    BoardTableDto getCustomerPoolTable(BoardQueryParam param);

    /**
     * 获取成交客户池数据表格
     * <p>
     * 返回表格数据，包含以下列：
     * - 分组（团队名或人员名）
     * - 加保客户数（来自add_keep_clients字段）
     * - 高客成交数（来自high_value_deals字段）
     * - 转介绍成交数（来自referral_deals字段）
     * - 缘故成交数（来自acquaintance_deals字段）
     * - 客户总数（优先使用monthly_deal_clients字段，如果为0则计算：加保 + 高客 + 转介绍 + 缘故）
     * <p>
     * 维度说明：
     * - team（团队指标）：只需要传入月份，内部会根据团队内的销售数据聚合，展示每个团队一行
     * - person（个人指标）：需要传入月份，如果传入teamId则只查询该团队下的销售数据，否则查询所有销售数据，展示每个销售一行
     * <p>
     * 包含分组行和总计行
     *
     * @param param 查询参数
     *              - dimension: team（团队指标）或 person（个人指标），必填
     *              - month: 月份，例如 "7月"、"8月"、"9月"，必填
     *              - teamId: 团队ID（部门ID），个人指标时可选：传入时只查询该团队下的销售，不传时查询所有销售；团队指标时不需要此参数
     * @return 表格数据（包含列名和行数据）
     */
    BoardTableDto getDealCustomerPoolTable(BoardQueryParam param);

    /**
     * 获取收入数据表格
     * <p>
     * 返回表格数据，包含以下列：
     * - 分组（团队名或人员名）
     * - 当月业绩（最新月份的业绩，来自performance字段）
     * - 当月件数（最新月份的件数，来自monthly_cases字段）
     * - 累积业绩（起始月份至最新月份的累计业绩，累计所有月份的performance）
     * - 累积件数（起始月份至最新月份的累计件数，累计所有月份的monthly_cases）
     * - 当月收入（最新月份的收入，来自income字段）
     * - 累积收入（起始月份至最新月份的累计收入，累计所有月份的income）
     * <p>
     * 维度说明：
     * - team（团队指标）：不需要月份筛选，内部会根据团队内的销售数据聚合，展示每个团队一行
     * - person（个人指标）：不需要月份筛选，如果传入teamId则只查询该团队下的销售数据，否则查询所有销售数据，展示每个销售一行
     * <p>
     * 自动显示当月（最新月）和累积（起始至最新月）数据
     * 包含分组行和总计行
     *
     * @param param 查询参数
     *              - dimension: team（团队指标）或 person（个人指标），必填
     *              - teamId: 团队ID（部门ID），个人指标时可选：传入时只查询该团队下的销售，不传时查询所有销售；团队指标时不需要此参数
     * @return 表格数据（包含列名和行数据）
     */
    BoardTableDto getIncomeTable(BoardQueryParam param);
}

