package cn.com.duiba.oto.enums.cust.follow;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-05 19:54
 * 客户跟进状态枚举
 */
@AllArgsConstructor
@Getter
public enum OtoFromAssignTypeEnum {

    CONTACT_TIMELY(1, "未及时跟进"),
    KYC_NOT_REPORT(2, "未提审报告||kyc"),
    ;

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 备注
     */
    private final String desc;

    private static final Map<Integer, String> FOLLOW_STATUS_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoFromAssignTypeEnum::getStatus, OtoFromAssignTypeEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据状态获取描述
     */
    public static String getDescByStatus(Integer status){
        if (status == null) {
            return null;
        }
        return FOLLOW_STATUS_MAP.get(status);
    }
}
