package cn.com.duiba.oto.oto.service.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.wx.UpdateAccessTokenDto;
import cn.com.duiba.oto.dto.oto.wx.WxUsersExtDto;

import java.util.List;

/**
 * @author xiaotian
 * @date 2023/01/28
 */
@AdvancedFeignClient
public interface RemoteWxUserExtService {

    List<WxUsersExtDto> selectByUserId(Long userId);


    WxUsersExtDto selectByUserIdAndOaId(Long userId, Long oaId);

    /**
     * 根据open ID查询
     *
     * @param openIds
     * @return
     */
    List<WxUsersExtDto> selectIdByOpenIds(List<String> openIds);

    /**
     * 根据id主键更新 ext信息
     *
     * @param dto
     * @return
     */
    Integer updateWxExt(WxUsersExtDto dto);

    /**
     * 批量新增
     *
     * @param usersExtDtoList
     * @return
     */
    Integer batchInsert(List<WxUsersExtDto> usersExtDtoList);

    /**
     * 批量跟新accessToken 小程序时 指的是 sessionKey
     *
     * @param updateAccessTokens
     * @return
     */
    Integer batchUpdateAccessToken(List<UpdateAccessTokenDto> updateAccessTokens);


    /**
     * 根据id删除用户
     *
     * @param userId
     * @return
     */
    boolean deleteById(Long userId);
}
