package cn.com.duiba.oto.enums.board;

/**
 * 看板维度类型枚举
 *
 * @author xiaotian
 * @date 2025-01-27
 */
public enum DimensionType {

    /**
     * 个人维度
     */
    PERSON("person"),

    /**
     * 团队维度
     */
    TEAM("team");

    private final String value;

    DimensionType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    /**
     * 根据字符串值获取枚举
     */
    public static DimensionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        for (DimensionType type : DimensionType.values()) {
            if (type.value.equals(value)) {
                return type;
            }
        }
        return null;
    }
}

