package cn.com.duiba.oto.enums.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-29 11:33
 */
@Getter
@AllArgsConstructor
public enum CustRegionEnum {

    IN_REGION(1, "本地客户"),
    OUT_REGION(2, "外地客户"),
    OUT_REGION_WITH_AGREE(3, "外地客户-销售确认跟进"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, CustRegionEnum> INNER_MAP = Arrays.stream(values()).collect(Collectors.toMap(CustRegionEnum::getType, Function.identity(), (v1, v2) -> v1));

    public static CustRegionEnum getByCode(Integer type) {
        return Objects.isNull(type) ? null : INNER_MAP.get(type);
    }
}
