package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * KPI指标数据DTO
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardKpiDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 月份标签列表
     */
    private List<String> monthLabels;

    /**
     * 10到3指标列表（新客转产说会率）
     */
    private List<Double> rate103List;

    /**
     * 3出1指标列表（产说会成交率）
     */
    private List<Double> rate3o1List;

    /**
     * 高客种草率列表
     */
    private List<Double> grassRateList;

    /**
     * 种草高客成交率列表（5出1指标）
     */
    private List<Double> grassDealRateList;
}

