package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 表格行DTO
 * 用于存储表格的一行数据
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardTableRowDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 第一列：分组名称（团队名或人员名，或"总计"）
     */
    private String groupName;

    /**
     * 其他列：指标值列表
     * 每个元素对应一个指标单元格，包含显示内容和提示信息
     */
    private List<BoardTableCellDto> cells;
}
