package cn.com.duiba.oto.oto.service.api.remoteservice.sms;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.param.oto.sms.BaseSmsTemplateParamBean;

/**
 * 阿里云短信服务
 *
 * @author ZhangJun
 * @date 2021/11/17 10:47 上午
 */
@AdvancedFeignClient
public interface RemoteOtoSmsService {

    /**
     * 发送短信
     * 返回true并不代表发送成功，请观察日志
     *
     * @param signType      短信签名 {@link cn.com.duiba.oto.enums.sms.SmsSignTypeEnum}
     * @param templateType  短信模版 {@link cn.com.duiba.oto.enums.sms.SmsTemplateTypeEnum}
     * @param templateParam 短信模版参数变量，需与短信模版相对应
     * @param phoneNums     手机号，多个时以英文逗号分隔，上限1000个
     * @return 发送结果
     */
    boolean send(Integer signType, Integer templateType, BaseSmsTemplateParamBean templateParam, String phoneNums);

    /**
     * 发送登陆短信验证码
     */
    boolean sendLoginSms(String phone, String code) throws BizException;
}