/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client;

import com.hitrust.trustpay.client.Base64;
import com.hitrust.trustpay.client.HiCalendar;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.XMLDocument;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocketFactory;

public class MerchantConfig {
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    public static final String KEY_STORE_TYPE_FILE = "0";
    public static final String KEY_STORE_TYPE_SIGN_SERVER = "1";
    public static final String KEY_STORE_TYPE_OTHERS = "3";
    private static String iKeyStoreType = "0";
    private static final String RESOURCE_NAME = "TrustMerchant";
    private static boolean iIsInitialed = false;
    private static ResourceBundle iResourceBundle = null;
    private static List iMerchantIDList = new ArrayList();
    private static List iMerchantCertificateList = new ArrayList();
    private static List iMerchantKeyList = new ArrayList();
    private static String iTrustPayConnectMethod = "http";
    private static String iTrustPayServerName = "";
    private static int iTrustPayServerPort = 0;
    private static String iTrustPayTrxURL = "";
    private static String iTrustPayIETrxURL = "";
    private static String iMerchantErrorURL = "";
    private static String iNewLine = "1";
    private static SSLSocketFactory iSSLSocketFactory = null;
    private static Certificate iTrustpayCertificate = null;
    private static String iLogPath = "";
    private static MerchantConfig uniqueInstanceOf_MerchantConfig = null;

    private MerchantConfig() throws TrxException {
        MerchantConfig.bundle();
    }

    private static synchronized void syncInit() throws TrxException {
        if (uniqueInstanceOf_MerchantConfig == null) {
            uniqueInstanceOf_MerchantConfig = new MerchantConfig();
        }
    }

    public static MerchantConfig getUniqueInstance() throws TrxException {
        if (uniqueInstanceOf_MerchantConfig == null) {
            MerchantConfig.syncInit();
        }
        return uniqueInstanceOf_MerchantConfig;
    }

    private static void bundle() throws TrxException {
        if (!iIsInitialed) {
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u5f00\u59cb====================");
            try {
                iResourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
            }
            catch (Exception e) {
                System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u65e0\u6cd5\u8bfb\u53d6\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6");
                throw new TrxException("1000", "\u65e0\u6cd5\u8bfb\u53d6\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6");
            }
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6");
            iTrustPayConnectMethod = MerchantConfig.getParameterByName("TrustPayConnectMethod");
            if (iTrustPayConnectMethod.length() == 0) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u901a\u8baf\u65b9\u5f0f[TrustPayConnectMethod]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u901a\u8baf\u65b9\u5f0f = [" + iTrustPayConnectMethod + "]");
            iTrustPayServerName = MerchantConfig.getParameterByName("TrustPayServerName");
            if (iTrustPayServerName.length() == 0) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u5668IP[TrustPayServerName]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u5668IP = [" + iTrustPayServerName + "]");
            String tTrustPayServerPort = MerchantConfig.getParameterByName("TrustPayServerPort");
            if (tTrustPayServerPort.length() == 0) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u4ea4\u6613\u7aef\u53e3[TrustPayServerPort]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            try {
                iTrustPayServerPort = Integer.parseInt(tTrustPayServerPort);
            }
            catch (Exception e) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u4ea4\u6613\u7aef\u53e3[TrustPayServerPort]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u4ea4\u6613\u7aef\u53e3 = [" + tTrustPayServerPort + "]");
            iTrustPayTrxURL = MerchantConfig.getParameterByName("TrustPayTrxURL");
            iTrustPayIETrxURL = MerchantConfig.getParameterByName("TrustPayIETrxURL");
            if (iTrustPayTrxURL.length() == 0 && iTrustPayIETrxURL.length() == 0) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u4ea4\u6613\u7f51\u5740[TrustPayTrxURL]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u4ea4\u6613\u7f51\u5740 = [" + iTrustPayTrxURL + "]");
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u5546\u6237\u901a\u8fc7\u6d4f\u89c8\u5668\u63d0\u4ea4\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u4ea4\u6613\u7f51\u5740 = [" + iTrustPayIETrxURL + "]");
            iMerchantErrorURL = MerchantConfig.getParameterByName("MerchantErrorURL");
            if (iTrustPayIETrxURL.length() != 0 && iMerchantErrorURL.length() == 0) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u4ea4\u6613\u7f51\u5740[MerchantErrorURL]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u5546\u6237\u901a\u8fc7\u6d4f\u89c8\u5668\u63d0\u4ea4\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u4ea4\u6613\u7f51\u5740 = [" + iMerchantErrorURL + "]");
            String tNewLine = MerchantConfig.getParameterByName("TrustPayNewLine");
            if (tNewLine.length() == 0) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u63a5\u53e3\u7279\u6027[TrustPayNewLine]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            iNewLine = tNewLine.equals(KEY_STORE_TYPE_SIGN_SERVER) ? "\n" : "\r\n";
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u63a5\u53e3\u7279\u6027 = [" + tNewLine + "]");
            String tTrustPayCertFile = MerchantConfig.getParameterByName("TrustPayCertFile");
            if (tTrustPayCertFile.length() == 0) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u8bc1\u4e66[tTrustPayCertFile]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            iTrustpayCertificate = MerchantConfig.getCertificate(tTrustPayCertFile);
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u8bc1\u4e66 = [" + tTrustPayCertFile + "]");
            iLogPath = MerchantConfig.getParameterByName("LogPath");
            if (iLogPath.length() == 0) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u5546\u6237\u65e5\u5fd7\u76ee\u5f55[LogPath]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u65e5\u5fd7\u6587\u4ef6\u76ee\u5f55 = [" + iLogPath + "]");
            MerchantConfig.initSSL();
            String iMerchantIDS = MerchantConfig.getParameterByName("MerchantID");
            if (iMerchantIDS.length() == 0) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u5546\u6237\u53f7[MerchantID]\u914d\u7f6e\u9519\u8bef\uff01");
            }
            StringTokenizer st = new StringTokenizer(iMerchantIDS, ",");
            while (st.hasMoreTokens()) {
                iMerchantIDList.add(st.nextToken());
            }
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u5546\u6237\u7f16\u53f7 = [" + iMerchantIDS + "]");
            iKeyStoreType = MerchantConfig.getParameterByName("MerchantKeyStoreType");
            if (iKeyStoreType.equals(KEY_STORE_TYPE_FILE)) {
                MerchantConfig.bindMerchantCertificateByFile();
            } else if (!iKeyStoreType.equals(KEY_STORE_TYPE_SIGN_SERVER)) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef - \u8bc1\u4e66\u50a8\u5b58\u5a92\u4f53\u914d\u7f6e\u9519\u8bef\uff01");
            }
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u5546\u6237\u8bc1\u4e66\u53ca\u79c1\u94a5\u521d\u59cb\u5b8c\u6210");
            iIsInitialed = true;
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u5b8c\u6210====================");
        }
    }

    private static void initSSL() throws TrxException {
        try {
            Provider tProvider = new Provider();
            SSLContext tSSLContext = SSLContext.getInstance((String)"TLS", (java.security.Provider)tProvider);
            System.out.println(KEY_STORE_TYPE_SIGN_SERVER);
            TrustManagerFactory tTrustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509", (java.security.Provider)tProvider);
            KeyStore tKeyStore = KeyStore.getInstance("JKS");
            tKeyStore.load(new FileInputStream(MerchantConfig.getParameterByName("TrustStoreFile")), MerchantConfig.getParameterByName("TrustStorePassword").toCharArray());
            tTrustManagerFactory.init(tKeyStore);
            TrustManager[] tTrustManager = tTrustManagerFactory.getTrustManagers();
            tSSLContext.init(null, tTrustManager, null);
            iSSLSocketFactory = tSSLContext.getSocketFactory();
        }
        catch (Exception e) {
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef" + e.getMessage());
            throw new TrxException("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef", e.getMessage());
        }
        catch (Error e) {
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - \u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef" + e.getMessage());
            throw new TrxException("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef", e.getMessage());
        }
        System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb - SSLSocketFactory\u5b8c\u6210");
    }

    private static Certificate getCertificate(String tCertFile) throws TrxException {
        Certificate tCertificate = null;
        byte[] tCertBytes = new byte[4096];
        int tCertBytesLen = 0;
        FileInputStream tIn = null;
        try {
            try {
                tIn = new FileInputStream(tCertFile);
                tCertBytesLen = tIn.read(tCertBytes);
            }
            catch (Exception e) {
                throw new TrxException("1002", "\u65e0\u6cd5\u8bfb\u53d6\u8bc1\u4e66\u6587\u6863[" + tCertFile + "]\uff01");
            }
        }
        finally {
            try {
                tIn.close();
            }
            catch (Exception exception) {}
        }
        byte[] tFinalCertBytes = new byte[tCertBytesLen];
        int i = 0;
        while (i < tCertBytesLen) {
            tFinalCertBytes[i] = tCertBytes[i];
            ++i;
        }
        Security.addProvider((java.security.Provider)new Provider());
        try {
            CertificateFactory tCertificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(tFinalCertBytes);
            if (bais.available() > 0) {
                tCertificate = tCertificateFactory.generateCertificate(bais);
            }
        }
        catch (Exception e) {
            throw new TrxException("1006", "\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef - \u65e0\u6cd5\u7531[" + tCertFile + "]\u751f\u6210X.509\u8bc1\u4e66\u5bf9\u8c61\uff01" + e.getMessage());
        }
        return tCertificate;
    }

    public static String getParameterByName(String aParamName) throws TrxException {
        if (iResourceBundle == null) {
            MerchantConfig.bundle();
        }
        String tValue = null;
        try {
            tValue = iResourceBundle.getString(aParamName).trim();
            if (tValue.equals("")) {
                throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", " - \u672a\u8bbe\u5b9a[" + aParamName + "]\u53c2\u6570\u503c!");
            }
        }
        catch (Exception e) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", " - \u65e0[" + aParamName + "]\u53c2\u6570!");
        }
        return tValue;
    }

    public static BufferedWriter getTrxLogFile() throws TrxException {
        return MerchantConfig.getTrxLogFile("TrxLog");
    }

    public static BufferedWriter getTrxLogFile(String aFileName) throws TrxException {
        MerchantConfig.bundle();
        BufferedWriter tLogFile = null;
        String tFileName = "";
        try {
            HiCalendar tHiCalendar = new HiCalendar();
            tFileName = String.valueOf(iLogPath) + System.getProperty("file.separator") + aFileName + tHiCalendar.toString(".%Y%m%d.log");
            tLogFile = new BufferedWriter(new FileWriter(tFileName, true));
        }
        catch (IOException e) {
            throw new TrxException("1004", "\u65e0\u6cd5\u5199\u5165\u4ea4\u6613\u65e5\u5fd7\u6587\u6863", " - \u7cfb\u7edf\u65e0\u6cd5\u5199\u5165\u4ea4\u6613\u65e5\u5fd7\u81f3[" + tFileName + "]\u4e2d!");
        }
        return tLogFile;
    }

    private static void bindMerchantCertificateByFile() throws TrxException {
        String tMerchantCertFiles = MerchantConfig.getParameterByName("MerchantCertFile");
        if (tMerchantCertFiles.length() == 0) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u5546\u6237\u8bc1\u4e66\u50a8\u5b58\u76ee\u5f55\u6863\u540d[MerchantCertFile]\u914d\u7f6e\u9519\u8bef\uff01");
        }
        String tMerchantCertPasswords = MerchantConfig.getParameterByName("MerchantCertPassword");
        if (tMerchantCertPasswords.length() == 0) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u5546\u6237\u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801[MerchantCertPassword]\u914d\u7f6e\u9519\u8bef\uff01");
        }
        StringTokenizer stCertFile = new StringTokenizer(tMerchantCertFiles, ",");
        StringTokenizer stCertPassword = new StringTokenizer(tMerchantCertPasswords, ",");
        if (stCertFile.countTokens() != stCertPassword.countTokens()) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u5546\u6237\u8bc1\u4e66\u50a8\u5b58\u76ee\u5f55\u6863\u540d[MerchantCertFile]\u6216\u5546\u6237\u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801[MerchantCertPassword]\u914d\u7f6e\u9519\u8bef\uff01");
        }
        ArrayList<String> tCertFileList = new ArrayList<String>();
        ArrayList<String> tCertPasswordList = new ArrayList<String>();
        while (stCertFile.hasMoreTokens()) {
            tCertFileList.add(stCertFile.nextToken());
        }
        while (stCertPassword.hasMoreTokens()) {
            tCertPasswordList.add(stCertPassword.nextToken());
        }
        int size = tCertFileList.size();
        int i = 0;
        while (i < size) {
            KeyStore tKeyStore = null;
            FileInputStream tIn = null;
            String tMerchantCertFile = (String)tCertFileList.get(i);
            String tMerchantCertPassword = (String)tCertPasswordList.get(i);
            try {
                try {
                    tIn = new FileInputStream(tMerchantCertFile);
                    tKeyStore = KeyStore.getInstance("PKCS12", new Provider().getName());
                    tKeyStore.load(tIn, tMerchantCertPassword.toCharArray());
                }
                catch (Exception e) {
                    throw new TrxException("1002", "\u65e0\u6cd5\u8bfb\u53d6\u8bc1\u4e66\u6587\u6863", "[" + tMerchantCertFile + "]\uff01" + e.getMessage());
                }
            }
            finally {
                if (tIn != null) {
                    try {
                        tIn.close();
                    }
                    catch (Exception exception) {}
                }
            }
            Certificate tCert = null;
            String tAliases = "";
            String iMerchantCertificate = null;
            String iMerchantID = (String)iMerchantIDList.get(i);
            try {
                Enumeration<String> e = tKeyStore.aliases();
                if (e.hasMoreElements()) {
                    tAliases = e.nextElement();
                }
                tCert = tKeyStore.getCertificate(tAliases);
                Base64 tBase64 = new Base64();
                iMerchantCertificate = tBase64.encode(tCert.getEncoded());
            }
            catch (Exception e) {
                throw new TrxException("1006", "\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef", "\u65e0\u6cd5\u5bf9\u8bc1\u4e66\u8fdb\u884c\u7f16\u7801\uff01");
            }
            iMerchantCertificateList.add(iMerchantCertificate);
            PrivateKey iMerchantKey = null;
            try {
                iMerchantKey = (PrivateKey)tKeyStore.getKey(tAliases, tMerchantCertPassword.toCharArray());
            }
            catch (Exception e) {
                throw new TrxException("1003", "\u65e0\u6cd5\u8bfb\u53d6\u5546\u6237\u79c1\u94a5", "\u65e0\u6cd5\u751f\u6210\u79c1\u94a5\u8bc1\u4e66\u5bf9\u8c61\uff01" + e.getMessage());
            }
            iMerchantKeyList.add(iMerchantKey);
            ++i;
        }
    }

    public String getMerchantID(int i) throws TrxException {
        return (String)iMerchantIDList.get(i - 1);
    }

    public String getMerchantCertificate(int i) throws TrxException {
        return (String)iMerchantCertificateList.get(i - 1);
    }

    public PrivateKey getMerchantKey(int i) throws TrxException {
        return (PrivateKey)iMerchantKeyList.get(i - 1);
    }

    public String getTrustPayConnectMethod() throws TrxException {
        return iTrustPayConnectMethod;
    }

    public String getKeyStoreType() throws TrxException {
        return iKeyStoreType;
    }

    public String getTrustPayServerName() throws TrxException {
        return iTrustPayServerName;
    }

    public int getTrustPayServerPort() throws TrxException {
        return iTrustPayServerPort;
    }

    public String getTrustPayNewLine() throws TrxException {
        return iNewLine;
    }

    public String getTrustPayTrxURL() throws TrxException {
        return iTrustPayTrxURL;
    }

    public String getTrustPayIETrxURL() throws TrxException {
        return iTrustPayIETrxURL;
    }

    public String getMerchantErrorURL() throws TrxException {
        return iMerchantErrorURL;
    }

    public SSLSocketFactory getSSLSocketFactory() throws TrxException {
        return iSSLSocketFactory;
    }

    public Certificate getTrustpayCertificate() throws TrxException {
        return iTrustpayCertificate;
    }

    public XMLDocument signMessage(int i, XMLDocument aMessage) throws TrxException {
        XMLDocument tMessage = null;
        try {
            String tKeyStoreType = this.getKeyStoreType();
            if (tKeyStoreType.equalsIgnoreCase(KEY_STORE_TYPE_FILE)) {
                tMessage = this.fileSignMessage(i, aMessage);
            } else if (tKeyStoreType.equalsIgnoreCase(KEY_STORE_TYPE_SIGN_SERVER)) {
                tMessage = this.signServerSignMessage(aMessage);
            }
        }
        catch (TrxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TrxException("1102", "\u7b7e\u540d\u4ea4\u6613\u62a5\u6587\u65f6\u53d1\u751f\u9519\u8bef - " + e.getMessage());
        }
        return tMessage;
    }

    private XMLDocument fileSignMessage(int i, XMLDocument aMessage) throws Exception {
        StringBuffer tMessage = new StringBuffer("");
        Signature tSignature = null;
        tSignature = Signature.getInstance(SIGNATURE_ALGORITHM);
        tSignature.initSign(this.getMerchantKey(i));
        tSignature.update(aMessage.toString().getBytes("UTF-8"));
        byte[] tSigned = tSignature.sign();
        Base64 tBase64 = new Base64();
        String tSignedBase64 = tBase64.encode(tSigned);
        tMessage.append("<Message>").append(aMessage.toString()).append("</Message>").append("<Signature-Algorithm>").append(SIGNATURE_ALGORITHM).append("</Signature-Algorithm>").append("<Signature>").append(tSignedBase64).append("</Signature>");
        return new XMLDocument(tMessage.toString());
    }

    private XMLDocument signServerSignMessage(XMLDocument aMessage) throws Exception {
        StringBuffer tMessage = new StringBuffer("");
        Socket tSocket = null;
        OutputStream tOut = null;
        BufferedReader tIn = null;
        String tSignServerIP = MerchantConfig.getParameterByName("SignServerIP");
        int tSignServerPort = Integer.parseInt(MerchantConfig.getParameterByName("SignServerPort"));
        String tSignServerPass = MerchantConfig.getParameterByName("SignServerPassword");
        try {
            try {
                tSocket = new Socket(InetAddress.getByName(tSignServerIP), tSignServerPort);
                Base64 tBase64 = new Base64();
                String tData = tBase64.encode(aMessage.toString().getBytes("UTF-8"));
                StringBuffer tSignRequest = new StringBuffer("").append("<SignReq>").append("<Password>").append(tSignServerPass).append("</Password>").append("<Signature-Algorithm>").append(SIGNATURE_ALGORITHM).append("</Signature-Algorithm>").append("<Data>").append(tData).append("</Data>").append("</SignReq>\n");
                tOut = tSocket.getOutputStream();
                tOut.write(tSignRequest.toString().getBytes("iso8859-1"));
                tOut.flush();
                tIn = new BufferedReader(new InputStreamReader(tSocket.getInputStream()));
                String tLine = tIn.readLine();
                if (tLine == null) {
                    throw new TrxException("1104", "\u7b7e\u540d\u670d\u52a1\u5668\u8fd4\u56de\u7b7e\u540d\u9519\u8bef", "\u65e0\u54cd\u5e94");
                }
                XMLDocument tSignedResponse = new XMLDocument(tLine);
                String tSignBase64 = "";
                if (!tSignedResponse.getValueNoNull("RC").equals(KEY_STORE_TYPE_FILE)) {
                    throw new TrxException("1104", "\u7b7e\u540d\u670d\u52a1\u5668\u8fd4\u56de\u7b7e\u540d\u9519\u8bef", "\u9519\u8bef\u4ee3\u7801[" + tSignedResponse.getValueNoNull("RC") + "]");
                }
                tSignBase64 = tSignedResponse.getValueNoNull("Signature");
                tMessage.append("<Message>").append(aMessage.toString()).append("</Message>").append("<Signature-Algorithm>").append(SIGNATURE_ALGORITHM).append("</Signature-Algorithm>").append("<Signature>").append(tSignBase64).append("</Signature>");
            }
            catch (TrxException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TrxException("1103", "\u65e0\u6cd5\u8fde\u7ebf\u7b7e\u540d\u670d\u52a1\u5668", e.getMessage());
            }
        }
        finally {
            if (tIn != null) {
                try {
                    tIn.close();
                }
                catch (Exception exception) {}
            }
            if (tOut != null) {
                try {
                    tOut.close();
                }
                catch (Exception exception) {}
            }
            if (tSocket != null) {
                try {
                    tSocket.close();
                }
                catch (Exception exception) {}
            }
        }
        return new XMLDocument(tMessage.toString());
    }

    public XMLDocument verifySign(XMLDocument aMessage) throws TrxException {
        XMLDocument tTrxResponse = aMessage.getValue("Message");
        if (tTrxResponse == null) {
            throw new TrxException("1301", "\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u4e0d\u5b8c\u6574", "\u65e0[Message]\u6bb5\uff01");
        }
        XMLDocument tAlgorithm = aMessage.getValue("Signature-Algorithm");
        if (tAlgorithm == null) {
            throw new TrxException("1301", "\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u4e0d\u5b8c\u6574", "\u65e0[Signature-Algorithm]\u6bb5\uff01");
        }
        XMLDocument tSignBase64 = aMessage.getValue("Signature");
        if (tSignBase64 == null) {
            throw new TrxException("1301", "\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u4e0d\u5b8c\u6574", "\u65e0[Signature]\u6bb5\uff01");
        }
        Base64 tBase64 = new Base64();
        byte[] tSign = tBase64.decode(tSignBase64.toString());
        try {
            Signature tSignature = Signature.getInstance(tAlgorithm.toString());
            tSignature.initVerify(this.getTrustpayCertificate());
            tSignature.update(tTrxResponse.toString().getBytes("gb2312"));
            if (!tSignature.verify(tSign)) {
                throw new TrxException("1302", "\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        catch (TrxException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new TrxException("1302", "\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25 - " + e.getMessage());
        }
        return tTrxResponse;
    }

    public static void main(String[] argc) {
    }
}

