/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.XMLDocument;
import java.util.ArrayList;

public class AgentBatchDetail {
    public static final String STATUS_UNDONE = "X";
    public static final String STATUS_SUCCESS = "0";
    public static final String STATUS_FAIL = "1";
    public static final String STATUS_NORESPONSE = "2";
    private String iMerchantNo = "";
    private int iExpiredDate = 30;
    private String iBatchNo = "";
    private String iBatchDate = "";
    private String iOrderNo = "";
    private double iOrderAmount = 0.0;
    private String iCurrency = "";
    private String iCertificateNo = "";
    private String iContractID = "";
    private String iProductID = "";
    private String iProductName = "";
    private int iProductNum = 0;
    private String iOrderStatus = "";
    public static final int ORDER_NO_LEN = 50;

    public AgentBatchDetail() {
    }

    public AgentBatchDetail(XMLDocument aXMLDocument) {
        this.setOrderNo(aXMLDocument.getValueNoNull("OrderNo"));
        try {
            this.setOrderAmount(Double.parseDouble(aXMLDocument.getValueNoNull("OrderAmount")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCertificateNo(aXMLDocument.getValueNoNull("CertificateNo"));
        this.setContractID(aXMLDocument.getValueNoNull("ContractID"));
        this.setProductID(aXMLDocument.getValueNoNull("ProductID"));
        this.setProductName(aXMLDocument.getValueNoNull("ProductName"));
        try {
            this.setProductNum(Integer.parseInt(aXMLDocument.getValueNoNull("ProductNum")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setOrderStatus(aXMLDocument.getValueNoNull("OrderStatus"));
        ArrayList tOrderItems = aXMLDocument.getDocuments("OrderItem");
        int i = 0;
        while (i < tOrderItems.size()) {
            ++i;
        }
    }

    public AgentBatchDetail setMerchantNo(String aMerchantNo) {
        this.iMerchantNo = aMerchantNo;
        return this;
    }

    public String getMerchantNo() {
        return this.iMerchantNo;
    }

    public AgentBatchDetail setExpiredDate(int aExpiredDate) {
        this.iExpiredDate = aExpiredDate;
        return this;
    }

    public int getExpiredDate() {
        return this.iExpiredDate;
    }

    public AgentBatchDetail setBatchNo(String aBatchNo) {
        this.iBatchNo = aBatchNo;
        return this;
    }

    public String getBatchNo() {
        return this.iBatchNo;
    }

    public AgentBatchDetail setBatchDate(String aBatchDate) {
        this.iBatchDate = aBatchDate;
        return this;
    }

    public String getBatchDate() {
        return this.iBatchDate;
    }

    public AgentBatchDetail setOrderNo(String aOrderNo) {
        this.iOrderNo = aOrderNo;
        return this;
    }

    public String getOrderNo() {
        return this.iOrderNo;
    }

    public AgentBatchDetail setOrderAmount(double aOrderAmount) {
        this.iOrderAmount = aOrderAmount;
        return this;
    }

    public double getOrderAmount() {
        return this.iOrderAmount;
    }

    public AgentBatchDetail setCurrency(String aCurrency) {
        this.iCurrency = aCurrency;
        return this;
    }

    public String getCurrency() {
        return this.iCurrency;
    }

    public AgentBatchDetail setCertificateNo(String aCertificateNo) {
        this.iCertificateNo = aCertificateNo;
        return this;
    }

    public String getCertificateNo() {
        return this.iCertificateNo;
    }

    public AgentBatchDetail setProductID(String aProductID) {
        this.iProductID = aProductID;
        return this;
    }

    public String getProductID() {
        return this.iProductID;
    }

    public AgentBatchDetail setProductName(String aProductName) {
        this.iProductName = aProductName;
        return this;
    }

    public String getProductName() {
        return this.iProductName;
    }

    public AgentBatchDetail setProductNum(int aProductNum) {
        this.iProductNum = aProductNum;
        return this;
    }

    public int getProductNum() {
        return this.iProductNum;
    }

    public AgentBatchDetail setContractID(String aContractID) {
        this.iContractID = aContractID;
        return this;
    }

    public String getContractID() {
        return this.iContractID;
    }

    public AgentBatchDetail setOrderStatus(String aOrderStatus) {
        this.iOrderStatus = aOrderStatus;
        return this;
    }

    public String getOrderStatus() {
        return this.iOrderStatus;
    }

    public String getStatusChinese(String aStatus) {
        String tStatusChinese = "";
        tStatusChinese = aStatus.equals(STATUS_UNDONE) ? "\u672a\u5904\u7406" : (aStatus.equals(STATUS_SUCCESS) ? "\u5904\u7406\u6210\u529f" : (aStatus.equals(STATUS_FAIL) ? "\u5904\u7406\u5931\u8d25" : (aStatus.equals(STATUS_NORESPONSE) ? "\u65e0\u56de\u5e94" : "\u672a\u77e5\u72b6\u6001")));
        return tStatusChinese;
    }

    public void checkRequest() throws TrxException {
        if (!DataVerifier.isValidString(this.iOrderNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidCertificateNo(this.iCertificateNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5ba2\u6237\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iContractID)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u7b7e\u7ea6\u534f\u8bae\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidAmount(this.iOrderAmount, 2)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8d26\u5355\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iProductID)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5546\u54c1\u7f16\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iProductName)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5546\u54c1\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
    }
}

