/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxRequest;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;

public class CBPNotifyRequest
extends TrxRequest {
    private String iCBPOrderNo = "";
    private String iStatus = "";
    private String iPayDate = "";
    private String iPayBankNo = "";
    private String iTrustPayCBPTrxURL = "";
    private String iTrustPayIECBPTrxURL = "";

    public String getITrustPayIECBPTrxURL() {
        return this.iTrustPayIECBPTrxURL;
    }

    public void setITrustPayIECBPTrxURL(String trustPayIECBPTrxURL) {
        this.iTrustPayIECBPTrxURL = trustPayIECBPTrxURL;
    }

    public String getITrustPayCBPTrxURL() {
        return this.iTrustPayCBPTrxURL;
    }

    public void setITrustPayCBPTrxURL(String trustPayCBPTrxURL) {
        this.iTrustPayCBPTrxURL = trustPayCBPTrxURL;
    }

    public CBPNotifyRequest() {
        super("B2C");
    }

    public CBPNotifyRequest(XMLDocument aXMLDocument) {
        super("B2C");
        this.setICBPOrderNo(aXMLDocument.getValueNoNull("CBPOrderNo"));
        this.setIStatus(aXMLDocument.getValueNoNull("Status"));
        this.setIPayDate(aXMLDocument.getValueNoNull("PayDate"));
        this.setIPayBankNo(aXMLDocument.getValueNoNull("PayBankNo"));
    }

    protected void checkRequest() throws TrxException {
        if (this.iCBPOrderNo == null) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u672a\u8bbe\u5b9a\u7b2c\u4e09\u65b9\u8d26\u5355\u53f7\uff01");
        }
        if (this.iStatus != "1" && this.iStatus != "2" && this.iStatus != "3" && this.iStatus == null) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u652f\u4ed8\u72b6\u6001\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidDateTime(this.iPayDate)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u652f\u4ed8\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    protected TrxResponse constructResponse(XMLDocument responseMessage) throws TrxException {
        TrxResponse tTrxResponse = null;
        String value = responseMessage.getValueNoNull("NotifyStatus");
        if (value.equals("TRUE")) {
            tTrxResponse = new TrxResponse("0000", "\u519c\u884c\u63a5\u6536\u901a\u77e5\u6210\u529f");
        } else if (value.equals("FALSE")) {
            tTrxResponse = new TrxResponse("0011", "\u519c\u884c\u63a5\u6536\u901a\u77e5\u5931\u8d25");
        }
        return tTrxResponse;
    }

    protected XMLDocument getRequestMessage() {
        StringBuffer tMessage = new StringBuffer("").append("<CBPOrderNo>").append(this.iCBPOrderNo).append("</CBPOrderNo>").append("<Status>").append(this.iStatus).append("</Status>").append("<PayDate>").append(this.iPayDate).append("</PayDate>").append("<PayBankNo>").append(this.iPayBankNo).append("</PayBankNo>");
        return new XMLDocument(tMessage.toString());
    }

    public String getICBPOrderNo() {
        return this.iCBPOrderNo;
    }

    public void setICBPOrderNo(String orderNo) {
        this.iCBPOrderNo = orderNo;
    }

    public String getIStatus() {
        return this.iStatus;
    }

    public void setIStatus(String status) {
        this.iStatus = status;
    }

    public String getIPayDate() {
        return this.iPayDate;
    }

    public void setIPayDate(String payDate) {
        this.iPayDate = payDate;
    }

    public String getIPayBankNo() {
        return this.iPayBankNo;
    }

    public void setIPayBankNo(String payBankNo) {
        this.iPayBankNo = payBankNo;
    }
}

