/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxRequest;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;
import com.hitrust.trustpay.client.b2c.Order;

public class FundPaymentRequest
extends TrxRequest {
    private Order iOrder = null;
    private String iProductType = "1";
    private String iNotifyType = "0";
    private String iPaymentType = "1";
    private String iResultNotifyURL = "";
    private String iMerchantRemarks = "";
    private String iTrxSubType = "";
    private String iCertificateNo = "";
    private String iCertificateType = "";
    private String iBankCardNo = "";
    public static final String PRD_TYPE_ONE = "1";
    public static final String PRD_TYPE_TWO = "2";
    public static final String PAY_TYPE_ABC = "1";
    public static final String PAY_TYPE_INT = "2";
    public static final String NOTIFY_TYPE_URL = "0";
    public static final String NOTIFY_TYPE_SERVER = "1";
    public static final int RESULT_NOTIFY_URL_LEN = 200;
    public static final int MERCHANT_REMARKS_LEN = 200;
    public static final String TRX_OPEN_ACCOUNT = "1";
    public static final String TRX_BUY_FUND = "2";

    public FundPaymentRequest() {
        super("B2C");
    }

    public FundPaymentRequest(XMLDocument aXMLDocument) {
        super("B2C");
        this.setOrder(new Order(aXMLDocument));
        this.setProductType(aXMLDocument.getValueNoNull("ProductType"));
        this.setPaymentType(aXMLDocument.getValueNoNull("PaymentType"));
        this.setNotifyType(aXMLDocument.getValueNoNull("NotifyType"));
        this.setResultNotifyURL(aXMLDocument.getValueNoNull("ResultNotifyURL"));
        this.setMerchantRemarks(aXMLDocument.getValueNoNull("MerchantRemarks"));
        this.setBankCardNo(aXMLDocument.getValueNoNull("BankCardNo"));
        this.setTrxSubType(aXMLDocument.getValueNoNull("TrxSubType"));
        this.setCertificateNo(aXMLDocument.getValueNoNull("CertificateNo"));
        this.setCertificateType(aXMLDocument.getValueNoNull("CertificateType"));
    }

    protected XMLDocument getRequestMessage() {
        StringBuffer tMessage = new StringBuffer("").append("<TrxRequest>").append("<TrxType>").append("FundPayReq").append("</TrxType>").append(this.iOrder.getXMLDocument(1).toString()).append("<ProductType>").append(this.iProductType).append("</ProductType>").append("<PaymentType>").append(this.iPaymentType).append("</PaymentType>").append("<NotifyType>").append(this.iNotifyType).append("</NotifyType>").append("<ResultNotifyURL>").append(this.iResultNotifyURL).append("</ResultNotifyURL>").append("<MerchantRemarks>").append(this.iMerchantRemarks).append("</MerchantRemarks>").append("<TrxSubType>").append(this.iTrxSubType).append("</TrxSubType>").append("<CertificateType>").append(this.iCertificateType).append("</CertificateType>").append("<CertificateNo>").append(this.iCertificateNo).append("</CertificateNo>").append("<BankCardNo>").append(this.iBankCardNo).append("</BankCardNo>").append("</TrxRequest>");
        return new XMLDocument(tMessage.toString());
    }

    protected void checkRequest() throws TrxException {
        if (this.iOrder == null) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u672a\u8bbe\u5b9a\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        if (this.iProductType == null) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u672a\u8bbe\u5b9a\u5546\u54c1\u79cd\u7c7b\uff01");
        }
        if (this.iResultNotifyURL == null) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u672a\u8bbe\u5b9a\u652f\u4ed8\u7ed3\u679c\u56de\u4f20\u7f51\u5740\uff01");
        }
        if (!this.iOrder.isValid()) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5408\u6cd5\uff01");
        }
        if (!this.iProductType.equals("1") && !this.iProductType.equals("2")) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5546\u54c1\u79cd\u7c7b\u4e0d\u5408\u6cd5\uff01");
        }
        if (!this.iPaymentType.equals("1") && !this.iPaymentType.equals("2")) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u652f\u4ed8\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01");
        }
        if (!this.iNotifyType.equals(NOTIFY_TYPE_URL) && !this.iNotifyType.equals("1")) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidURL(this.iResultNotifyURL)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u652f\u4ed8\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.iResultNotifyURL.length() == 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u652f\u4ed8\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.iResultNotifyURL.getBytes().length > 200) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u652f\u4ed8\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.iMerchantRemarks.getBytes().length > 200) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5546\u6237\u5907\u6ce8\u4fe1\u606f\u4e0d\u5408\u6cd5\uff01");
        }
        if (!this.iTrxSubType.equals("1") && !this.iTrxSubType.equals("2")) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u5b50\u7c7b\u578b\u4fe1\u606f\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.iTrxSubType.equals("1") && (this.iCertificateNo.trim().length() == 0 || this.iCertificateType.trim().length() == 0)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5");
        }
        if (this.iBankCardNo.trim().length() == 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5");
        }
    }

    protected TrxResponse constructResponse(XMLDocument aResponseMessage) throws TrxException {
        return new TrxResponse(aResponseMessage);
    }

    public FundPaymentRequest setOrder(Order aOrder) {
        this.iOrder = aOrder;
        return this;
    }

    public Order getOrder() {
        return this.iOrder;
    }

    public FundPaymentRequest setProductType(String aProductType) {
        this.iProductType = aProductType;
        return this;
    }

    public String getProductType() {
        return this.iProductType;
    }

    public FundPaymentRequest setPaymentType(String aPaymentType) {
        this.iPaymentType = aPaymentType;
        return this;
    }

    public String getPaymentType() {
        return this.iPaymentType;
    }

    public FundPaymentRequest setNotifyType(String aNotifyType) {
        this.iNotifyType = aNotifyType;
        return this;
    }

    public String getNotifyType() {
        return this.iNotifyType;
    }

    public FundPaymentRequest setResultNotifyURL(String aResultNotifyURL) {
        this.iResultNotifyURL = aResultNotifyURL.trim();
        return this;
    }

    public String getResultNotifyURL() {
        return this.iResultNotifyURL;
    }

    public FundPaymentRequest setMerchantRemarks(String aMerchantRemarks) {
        this.iMerchantRemarks = aMerchantRemarks.trim();
        return this;
    }

    public String getMerchantRemarks() {
        return this.iMerchantRemarks;
    }

    public FundPaymentRequest setTrxSubType(String aTrxSubType) {
        this.iTrxSubType = aTrxSubType;
        return this;
    }

    public String getTrxSubType() {
        return this.iTrxSubType;
    }

    public FundPaymentRequest setCertificateType(String aCertificateType) {
        this.iCertificateType = aCertificateType;
        return this;
    }

    public String getCertificateType() {
        return this.iCertificateType;
    }

    public FundPaymentRequest setCertificateNo(String aCertificateNo) {
        this.iCertificateNo = aCertificateNo;
        return this;
    }

    public String getCertificateNo() {
        return this.iCertificateNo;
    }

    public FundPaymentRequest setBankCardNo(String aBankCardNo) {
        this.iBankCardNo = aBankCardNo;
        return this;
    }

    public String getBankCardNo() {
        return this.iBankCardNo;
    }
}

