/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.Base64;
import com.hitrust.trustpay.client.LogWriter;
import com.hitrust.trustpay.client.MerchantConfig;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.XMLDocument;
import java.io.UnsupportedEncodingException;

public class MerchantCBPRefundResult {
    private LogWriter iLogWriter;
    protected MerchantConfig tMerchantConfig;
    private String iOrdId;
    private String iRefOrdId;
    private String iTransType;
    private double iTransAmt;
    private String iReturnCode;
    private String iErrorMsg;

    public MerchantCBPRefundResult setOrdId(String aOrdId) {
        this.iOrdId = aOrdId;
        return this;
    }

    public String getOrdId() {
        return this.iOrdId;
    }

    public MerchantCBPRefundResult setRefOrdId(String aRefOrdId) {
        this.iRefOrdId = aRefOrdId;
        return this;
    }

    public String getRefOrdId() {
        return this.iRefOrdId;
    }

    public MerchantCBPRefundResult setTransType(String aTransType) {
        this.iTransType = aTransType;
        return this;
    }

    public String getTransType() {
        return this.iTransType;
    }

    public MerchantCBPRefundResult setTransAmount(double aRefundAmount) {
        this.iTransAmt = aRefundAmount;
        return this;
    }

    public double getTransAmount() {
        return this.iTransAmt;
    }

    public MerchantCBPRefundResult setReturnCode(String aReturnCode) {
        this.iReturnCode = aReturnCode.trim();
        return this;
    }

    public String getReturnCode() {
        return this.iReturnCode;
    }

    public MerchantCBPRefundResult setErrorMessage(String aErrorMessage) {
        this.iErrorMsg = aErrorMessage.trim();
        return this;
    }

    public String getErrorMessage() {
        return this.iErrorMsg;
    }

    public MerchantCBPRefundResult(String aMessage) throws TrxException, UnsupportedEncodingException {
        block12: {
            this.iLogWriter = null;
            this.tMerchantConfig = null;
            this.iOrdId = "";
            this.iRefOrdId = "";
            this.iTransType = "";
            this.iTransAmt = 0.0;
            this.iReturnCode = "";
            this.iErrorMsg = "";
            LogWriter tLogWriter = null;
            try {
                try {
                    tLogWriter = new LogWriter();
                    tLogWriter.logNewLine("CBPTrustPayClient Java V2.0\u9a8c\u8bc1\u519c\u884c\u652f\u4ed8\u5e73\u53f0\u9000\u6b3e\u8bf7\u6c42\u5f00\u59cb==========================");
                    tLogWriter.logNewLine("CBP\u63a5\u6536\u5230\u7684\u519c\u884c\u652f\u4ed8\u5e73\u53f0\u9000\u6b3e\u8bf7\u6c42\uff1a\n[" + aMessage + "]");
                    Base64 tBase64 = new Base64();
                    String tMessage = new String(tBase64.decode(aMessage), "gb2312");
                    tLogWriter.logNewLine("\u7ecf\u8fc7Base64\u89e3\u7801\u540e\u7684\u9000\u6b3e\u8bf7\u6c42\uff1a\n[" + tMessage + "]");
                    tLogWriter.logNewLine("\u9a8c\u8bc1\u9000\u6b3e\u8bf7\u6c42\u7684\u7b7e\u540d\uff1a");
                    XMLDocument tResult = MerchantConfig.getUniqueInstance().verifySign(new XMLDocument(tMessage));
                    tLogWriter.logNewLine("\u9a8c\u8bc1\u901a\u8fc7\uff01\n \u7ecf\u8fc7\u9a8c\u8bc1\u7684\u9000\u6b3e\u8bf7\u6c42\uff1a\n[" + tResult.toString() + "]");
                    this.initCBP(tResult);
                    this.setReturnCode("0000");
                    this.setErrorMessage("\u4ea4\u6613\u6210\u529f");
                }
                catch (TrxException e) {
                    tLogWriter.log("\u9a8c\u8bc1\u5931\u8d25\uff01\n");
                    this.setReturnCode(e.getCode());
                    this.setErrorMessage(String.valueOf(e.getMessage()) + "-" + e.getDetailMessage());
                    if (tLogWriter == null) break block12;
                    tLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                    try {
                        tLogWriter.closeWriter(MerchantConfig.getTrxLogFile("CBPRefundLog"));
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (tLogWriter != null) {
                    tLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                    try {
                        tLogWriter.closeWriter(MerchantConfig.getTrxLogFile("CBPRefundLog"));
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected void initCBP(XMLDocument aXMLDocument) throws TrxException {
        XMLDocument tOrdId = aXMLDocument.getValue("OrdId");
        if (tOrdId == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[OrdId]!");
        }
        this.setOrdId(tOrdId.toString());
        XMLDocument tRefOrdId = aXMLDocument.getValue("RefOrdId");
        if (tRefOrdId == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[RefOrdId]!");
        }
        this.setRefOrdId(tRefOrdId.toString());
        XMLDocument tTransType = aXMLDocument.getValue("TransType");
        if (tTransType == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[TransType]!");
        }
        this.setTransType(tTransType.toString());
        XMLDocument tTransAmount = aXMLDocument.getValue("TransAmt");
        if (tTransAmount == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[TransAmt]!");
        }
        this.setTransAmount(Double.parseDouble(tTransAmount.toString()));
    }

    public String genSignature(int i, String RequestMessage) throws TrxException {
        String tResponseMesg = "";
        try {
            try {
                this.iLogWriter = new LogWriter();
                this.iLogWriter.logNewLine("CBP\u7b2c\u4e09\u65b9\u652f\u4ed8\u5e73\u53f0\u54cd\u5e94\u519c\u884c\u9000\u6b3e\u8bf7\u6c42\u4ea4\u6613\u5f00\u59cb==========================");
                this.tMerchantConfig = MerchantConfig.getUniqueInstance();
                this.iLogWriter.logNewLine("\u7b2c\u4e09\u65b9\u652f\u4ed8\u5e73\u53f0\u9000\u6b3e\u54cd\u5e94\u62a5\u6587\uff1a");
                this.iLogWriter.logNewLine(RequestMessage);
                this.iLogWriter.logNewLine("\u5b8c\u6574\u9000\u6b3e\u54cd\u5e94\u62a5\u6587\uff1a");
                XMLDocument tRequestMessage = new XMLDocument(RequestMessage);
                this.iLogWriter.logNewLine("\u54cd\u5e94\u7b7e\u540d\u540e\u7684\u62a5\u6587\uff1a");
                tRequestMessage = this.tMerchantConfig.signMessage(i, tRequestMessage);
                StringBuffer tTempStringBuffer = new StringBuffer("").append("<MSG>").append(tRequestMessage.toString()).append("</MSG>");
                tResponseMesg = tTempStringBuffer.toString();
                this.iLogWriter.logNewLine("\u8fd4\u56de\u7ed9\u519c\u884c\u652f\u4ed8\u5e73\u53f0\u7684\u9000\u6b3e\u62a5\u6587\uff1a\n" + tResponseMesg);
                Base64 tBase64 = new Base64();
                tResponseMesg = tBase64.encode(tResponseMesg.getBytes("gb2312"));
                this.iLogWriter.logNewLine("\u8fd4\u56de\u7ed9\u519c\u884c\u652f\u4ed8\u5e73\u53f0\u7ecf\u8fc7Base64\u52a0\u5bc6\u7684\u9000\u6b3e\u62a5\u6587\uff1a\n" + tResponseMesg);
            }
            catch (TrxException e) {
                if (this.iLogWriter != null) {
                    this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[" + e.getCode() + "]    \u9519\u8bef\u4fe1\u606f\uff1a[" + e.getMessage() + " - " + e.getDetailMessage() + "]");
                }
                throw new TrxException(e.getCode(), String.valueOf(e.getMessage()) + " - " + e.getDetailMessage());
            }
            catch (Exception e) {
                if (this.iLogWriter != null) {
                    this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[1999]    \u9519\u8bef\u4fe1\u606f\uff1a[\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage() + "]");
                }
                throw new TrxException("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage());
            }
        }
        finally {
            if (this.iLogWriter != null) {
                this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                try {
                    this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile("CBPRefundLog"));
                }
                catch (Exception exception) {}
            }
        }
        return tResponseMesg;
    }
}

