/*
 * Decompiled with CFR 0.152.
 */
package com.abc.ebuspay.sdk;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Base64;

public class EBusPayUtil {
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";

    public static String signRequest(byte[] merchantPrivateKey, String merchantPrivateKeyPassword, String message) throws Exception {
        Signature tSignature = Signature.getInstance(SIGNATURE_ALGORITHM);
        KeyStore tKeyStore = KeyStore.getInstance("PKCS12", new Provider().getName());
        tKeyStore.load(new ByteArrayInputStream(merchantPrivateKey), merchantPrivateKeyPassword.toCharArray());
        Enumeration<String> e = tKeyStore.aliases();
        String tAliases = null;
        if (e.hasMoreElements()) {
            tAliases = e.nextElement();
        }
        PrivateKey iMerchantKey = (PrivateKey)tKeyStore.getKey(tAliases, merchantPrivateKeyPassword.toCharArray());
        tSignature.initSign(iMerchantKey);
        tSignature.update(message.toString().getBytes("UTF-8"));
        String signatureInBase64 = new String(Base64.encodeBase64((byte[])tSignature.sign()), "UTF-8");
        String signedRequest = "{\"Message\":" + message + "," + "\"Signature-Algorithm\":" + "\"" + SIGNATURE_ALGORITHM + "\"" + "," + "\"Signature\":" + "\"" + signatureInBase64 + "\"}";
        return signedRequest;
    }

    public static boolean verifyResponse(String signatureAlgorithm, String signature, String message, byte[] trustPayCert) throws Exception {
        Security.addProvider((java.security.Provider)new Provider());
        CertificateFactory tCertificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream trustPayCertInByteArray = new ByteArrayInputStream(trustPayCert);
        Certificate certificate = null;
        if (trustPayCertInByteArray.available() > 0) {
            certificate = tCertificateFactory.generateCertificate(trustPayCertInByteArray);
        }
        byte[] signatureInBytes = Base64.decodeBase64((byte[])signature.getBytes("GBK"));
        Signature signatureInstance = Signature.getInstance(SIGNATURE_ALGORITHM);
        signatureInstance.initVerify(certificate);
        signatureInstance.update(message.getBytes("GBK"));
        return signatureInstance.verify(signatureInBytes);
    }
}

