/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client;

public class Base64 {
    private static final int LOWER_CASE_A_VALUE = 26;
    private static final int ZERO_VALUE = 52;
    private static final int PLUS_VALUE = 62;
    private static final int SLASH_VALUE = 63;
    private static final int SIX_BIT_MASK = 63;
    private static final int EIGHT_BIT_MASK = 255;
    private String mString;
    private int mIndex = 0;

    public String encode(byte[] data) {
        int charCount = data.length * 4 / 3 + 4;
        StringBuffer result = new StringBuffer(charCount * 77 / 76);
        int byteArrayLength = data.length;
        int byteArrayIndex = 0;
        int byteTriplet = 0;
        while (byteArrayIndex < byteArrayLength - 2) {
            byteTriplet = this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byteTriplet |= this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byte b4 = (byte)(0x3F & (byteTriplet |= this.convertUnsignedByteToInt(data[byteArrayIndex++])));
            byte b3 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b2 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(this.mapByteToChar(b1));
            result.append(this.mapByteToChar(b2));
            result.append(this.mapByteToChar(b3));
            result.append(this.mapByteToChar(b4));
        }
        if (byteArrayIndex == byteArrayLength - 1) {
            byteTriplet = this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byte b2 = (byte)(0x3F & (byteTriplet <<= 4));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(this.mapByteToChar(b1));
            result.append(this.mapByteToChar(b2));
            result.append("==");
        }
        if (byteArrayIndex == byteArrayLength - 2) {
            byteTriplet = this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byteTriplet |= this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byte b3 = (byte)(0x3F & (byteTriplet <<= 2));
            byte b2 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(this.mapByteToChar(b1));
            result.append(this.mapByteToChar(b2));
            result.append(this.mapByteToChar(b3));
            result.append("=");
        }
        return result.toString();
    }

    public byte[] decode(String data) {
        this.mString = data;
        this.mIndex = 0;
        int mUsefulLength = 0;
        int length = this.mString.length();
        for (int i = 0; i < length; ++i) {
            if (!this.isUsefulChar(this.mString.charAt(i))) continue;
            ++mUsefulLength;
        }
        int byteArrayLength = mUsefulLength * 3 / 4;
        byte[] result = new byte[byteArrayLength];
        int byteTriplet = 0;
        int byteIndex = 0;
        while (byteIndex + 2 < byteArrayLength) {
            byteTriplet = this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            result[byteIndex + 2] = (byte)((byteTriplet |= this.mapCharToInt(this.getNextUsefulChar())) & 0xFF);
            result[byteIndex + 1] = (byte)((byteTriplet >>= 8) & 0xFF);
            result[byteIndex] = (byte)((byteTriplet >>= 8) & 0xFF);
            byteIndex += 3;
        }
        if (byteIndex == byteArrayLength - 1) {
            byteTriplet = this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            result[byteIndex] = (byte)((byteTriplet >>= 4) & 0xFF);
        }
        if (byteIndex == byteArrayLength - 2) {
            byteTriplet = this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            result[byteIndex + 1] = (byte)((byteTriplet >>= 2) & 0xFF);
            result[byteIndex] = (byte)((byteTriplet >>= 8) & 0xFF);
        }
        return result;
    }

    private int mapCharToInt(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        throw new IllegalArgumentException(c + " is not a valid Base64 character.");
    }

    private char mapByteToChar(byte b) {
        if (b < 26) {
            return (char)(65 + b);
        }
        if (b < 52) {
            return (char)(97 + (b - 26));
        }
        if (b < 62) {
            return (char)(48 + (b - 52));
        }
        if (b == 62) {
            return '+';
        }
        if (b == 63) {
            return '/';
        }
        throw new IllegalArgumentException("Byte " + new Integer(b) + " is not a valid Base64 value");
    }

    private boolean isUsefulChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '+' || c == '/';
    }

    private char getNextUsefulChar() {
        char result = '_';
        while (!this.isUsefulChar(result)) {
            result = this.mString.charAt(this.mIndex++);
        }
        return result;
    }

    private int convertUnsignedByteToInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public static void main(String[] args) throws Exception {
        String astring = "";
        Base64 tBase64 = new Base64();
        String result = new String(tBase64.decode("eyJQYXlUeXBlSUQiOiJJbW1lZGlhdGVQYXkiLCJPcmRlck5vIjoiTm82MzYwNTkwNTI1Mzg5OTg0MDciLCJPcmRlckRhdGUiOiIyMDE2LzA4LzA0IiwiT3JkZXJUaW1lIjoiMTE6MDI6MzYiLCJPcmRlckFtb3VudCI6IjIzIiwiU3RhdHVzIjoiMDQiLCJPcmRlckRlc2MiOiJHYW1lIENhcmQgT3JkZXIiLCJPcmRlclVSTCI6Imh0dHA6Ly8xMjcuMC4wLjEvTWVyY2hhbnQvTWVyY2hhbnRRdWVyeU9yZGVyLmFzcHg/T049T04yMDA0MTIyMzAwMDFcdTAwMjZEZXRhaWxRdWVyeT0xIiwiUGF5bWVudExpbmtUeXBlIjoiMSIsIkFjY3RObyI6IjYyMjg0ODAwMTAwKioqKjAxMTYiLCJDb21tb2RpdHlUeXBlIjoiMDEwMSIsIlJlY2VpdmVyQWRkcmVzcyI6IrGxvqkiLCJCdXlJUCI6IiIsImlSc3BSZWYiOiI4NEVDRVAwMTEwMzczODcwNjk5MCIsIlJlY2VpdmVBY2NvdW50IjoiMDIwMTAwMDE5NDEwMDAwMzMiLCJSZWNlaXZlQWNjTmFtZSI6Isbz0rW7pyIsIk1lcmNoYW50UmVtYXJrcyI6IiIsIk9yZGVySXRlbXMiOlt7IlN1Yk1lck5hbWUiOiKy4srUtv68tsnMu6cxIiwiU3ViTWVySWQiOiIxMjM0NSIsIlN1Yk1lck1DQyI6IjAwMDAiLCJTdWJNZXJjaGFudFJlbWFya3MiOiKy4srUIiwiUHJvZHVjdElEIjoiSVAwMDAwMDEiLCJQcm9kdWN0TmFtZSI6ItbQufrSxravSVC/qCIsIlVuaXRQcmljZSI6IjEiLCJRdHkiOiIxIiwiUHJvZHVjdFJlbWFya3MiOiKy4srUyczGtyJ9LHsiU3ViTWVyTmFtZSI6IrLiytS2/ry2ycy7pzEiLCJTdWJNZXJJZCI6IjEyMzQ1IiwiU3ViTWVyTUNDIjoiMDAwMCIsIlN1Yk1lcmNoYW50UmVtYXJrcyI6IrLiytQiLCJQcm9kdWN0SUQiOiJJUDAwMDAwMSIsIlByb2R1Y3ROYW1lIjoi1tC5+tLGtq9JUL+oIiwiVW5pdFByaWNlIjoiMSIsIlF0eSI6IjIiLCJQcm9kdWN0UmVtYXJrcyI6IrLiytTJzMa3In1dfQ=="));
        System.out.println("result " + result);
    }
}

